' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System
Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa CommentManagerDB odpowiada za wprowadzanie i usuwanie komentarzy z bazy danych.
''' </summary>
''' <remarks></remarks>
Public Class CommentManagerDB

#Region "Konstruktor(y)"

  Private Sub New()
  ' Ukryj konstruktor, poniewa ta klasa ma wycznie skadniki o dostpie wspdzielonym.
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Zwraca list komentarzy dla danego bdu.
  ''' </summary>
  ''' <param name="bugId">Identyfikator bdu w bazie danych.</param>
  Public Shared Function GetCommentList(ByVal bugId As Integer) As DataSet
    Dim myDataSet As DataSet = New DataSet
    Dim sql As String = "sprocCommentSelectList"

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.AddWithValue("@bugId", bugId)

        myConnection.Open()
        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()

        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Wstawia nowy komentarz do bazy danych i kojarzy go z bdem.
  ''' </summary>
  ''' <param name="bugId">Identyfikator bdu, do ktrego naley ten komentarz.</param>
  ''' <param name="theBody">Konkretny komentarz.</param>
  ''' <param name="theMemberId">Identyfikator uytkownika, ktry doda komentarz.</param>
  ''' <remarks></remarks>
  Public Shared Sub InsertComment(ByVal bugId As Integer, ByVal theBody As String, ByVal theMemberId As Guid)
    Dim sql As String = "sprocCommentInsertUpdateSingleItem"
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.AddWithValue("@bugId", bugId)
        myCommand.Parameters.AddWithValue("@body", theBody)
        myCommand.Parameters.AddWithValue("@createMemberId", theMemberId)

        myConnection.Open()
        myCommand.ExecuteNonQuery()
        myConnection.Close()

      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Sub

#End Region

End Class